#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <math.h>

// 要素を交換するマクロ
#define swap(a, b) do { \
    double t = (a);     \
    a = b;              \
    b = t;              \
} while( 0 );

/*
 * 行列用構造体
 * rows: 行数
 * cols: 列数
 * elems: 行列要素を入れた一次元配列
 */
typedef struct {
    int rows;
    int cols;
    double *elems;
} matrix;

// 行列要素を取得するマクロ
#define mat_elem(m, i, j) (m).elems[(i) * (m).cols + (j)]

// ----------------------------------------------------------------------------
// 行列演算用関数群
// ----------------------------------------------------------------------------

// mat_alloc: 行列要素用のメモリを確保する
bool mat_alloc(matrix *mat, int rows, int cols) {
    return false;
}

// mat_free: 使い終わった行列のメモリを解放する
void mat_free(matrix *mat) {
}

// mat_print: 行列の中身を表示する
void mat_print(matrix mat) {
    if (mat.rows == 0 || mat.cols == 0 || mat.elems == NULL) {
        fprintf(stderr, "Matrix is NULL or zero size!\n");
        return;
    }

    for (int i = 0; i < mat.rows; i++) {
        for (int j = 0; j < mat.cols; j++) {
            printf("%6.4f%s", mat_elem(mat, i, j), (j == mat.cols - 1) ? "\n" : "  ");
        }
    }
}

// mat_copy: srcの中身を*dstにコピーする
bool mat_copy(matrix *dst, matrix src) {
    return false;
}

// mat_add: mat1+mat2を*resに代入する
bool mat_add(matrix *res, matrix mat1, matrix mat2) {
    return false;
}

// mat_sub: mat1-mat2を*resに代入する
bool mat_sub(matrix *res, matrix mat1, matrix mat2) {
    return false;
}

// mat_mul: mat1とmat2の行列積を*resに代入する
bool mat_mul(matrix *res, matrix mat1, matrix mat2) {
    return false;
}

// mat_muls: matをc倍（スカラー倍）した結果を*resに代入する
bool mat_muls(matrix *res, matrix mat, double c) {
    return false;
}

// mat_trans: matの転置行列を*resに代入する
bool mat_trans(matrix *res, matrix mat) {
    return false;
}

// mat_unit: 単位行列を与える
bool mat_ident(matrix *mat) {
    return false;
}

// mat_equal: mat1とmat2が等しければtrueを返す
bool mat_equal(matrix mat1, matrix mat2) {
    return false;
}

// mat_solve: 連立一次方程式 ax=b を解く．ピボット選択付き
bool mat_solve(matrix *x, matrix A_, matrix b_) {
    return false;
}

// mat_inverse: 行列Aの逆行列を*invAに与える
bool mat_inverse(matrix *invA, matrix A) {
    return false;
}
